<?php
include("connexion.php");

// Traitement du téléchargement de la photo de profil
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_FILES['photo_profil'])) {
    $file = $_FILES['photo_profil'];

    // Vérifiez si le fichier est une image
    $allowed_types = ['image/jpeg', 'image/png', 'image/gif'];
    if (in_array($file['type'], $allowed_types)) {
        $upload_dir = "uploads/default.avif"; // Répertoire de destination
        $file_name = basename($file['name']);
        $target_file = $upload_dir . uniqid() . '_' . $file_name; // Renommer le fichier pour éviter les conflits

        // Déplacez le fichier téléchargé
        if (move_uploaded_file($file['tmp_name'], $target_file)) {
            // Mettez à jour la base de données avec le chemin de la photo
            $stmt = $db->prepare("UPDATE utilisateurs SET photo_profil = :photo_profil WHERE login = :login");
            $stmt->bindValue(':photo_profil', $target_file, PDO::PARAM_STR);
            $stmt->bindValue(':login', $_SESSION['login'], PDO::PARAM_STR);
            $stmt->execute();

            echo "Photo de profil mise à jour avec succès.";
        } else {
            echo "Erreur lors du téléchargement de la photo.";
        }
    } else {
        echo "Seules les images JPEG, PNG et GIF sont autorisées.";
    }
}

// Récupérer la photo de profil actuelle
$stmt = $db->prepare("SELECT photo_profil FROM utilisateurs WHERE login = :login");
$stmt->bindValue(':login', $_SESSION['login'], PDO::PARAM_STR);
$stmt->execute();
$result = $stmt->fetch(PDO::FETCH_ASSOC);
$current_photo = $result['photo_profil'] ?? 'default.png'; // Image par défaut si aucune photo

?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Changer Photo de Profil</title>
    <link href="CSS/pp.css" rel="stylesheet">
</head>
<body>

<header>
<div class="logo"><a href="utilisateurlogue.php">Blogies</a></div>
    <div class="nav-buttons">
        <a class="deco" href="utilisateurlogue.php">Accueil</a>
        <a class="deco" href="index.php">Déconnexion</a>
        <?php
        $stmt = $db->prepare("SELECT photo_profil FROM utilisateurs WHERE login = :login");
        $stmt->bindValue(':login', $_SESSION['login'], PDO::PARAM_STR);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $photo_profil = $result['photo_profil'] ?? "uploads/default.avif";
        echo "<a href='pp.php'><img src='" . htmlspecialchars($photo_profil) . "' class='photo-profil' alt='Photo de profil' style='width:40px;height:40px;border-radius:50%;margin-bottom:0;'></a>";
        ?>
    </div>
</header>

<h2>Changer votre photo de profil</h2>

<!-- Afficher la photo de profil actuelle -->
<img src="<?php echo htmlspecialchars($current_photo); ?>" alt="Photo de profil">

<form action="pp.php" method="post" enctype="multipart/form-data">
    <input type="file" name="photo_profil" accept="image/*" required>
    <input type="submit" value="Télécharger">
</form>

<div class="retour">
<a href="utilisateurlogue.php">Retour</a>
</div>

</body>
</html>